/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;

import jp.mosp.payroll.dto.CompileAmendmentDto;

public class CompileAmendmentListVo extends AttendanceCalculateMenuVo {

	private static final long serialVersionUID = -8518087820826308466L;

	// URLAJSt@CACSSt@C
	private static final String RETURN_URL = "/jsp/payroll/compileAmendmentList.jsp";
	private static final String EXTRA_JS   = "/pub/payroll/js/compileAmendmentList.js";
	private static final String EXTRA_CSS  = "/pub/payroll/css/compileAmendmentList.css";

	// ʃTu^Cg
	public final String SUB_TITLE = CommonConst.TTL_ATT_CALCULATE_AMENDMENT;

	//萔
	public static final int SEARCH_OFF 		= 0;
	public static final int SEARCH_ON  		= 1;
	public static final int MODE_IMPOSSIBLE 	= 0;
	public static final int MODE_POSSIBLE 	= 1;

	// p[^
	public static final String PRM_TXT_K_CODE 		= "txtKCode";
	public static final String PRM_TXT_K_NAME 		= "txtKName";
	public static final String PRM_PLT_SECTION 		= "pltSection";
	public static final String PRM_PLT_YEAR			= "pltYear";
	public static final String PRM_PLT_MONTH 			= "pltMonth";
	public static final String PRM_PLT_APPROVAL 		= "pltApproval";
	public static final String PRM_PLT_COMPILE 		= "pltCompile";
	public static final String PRM_HID_SELECT_DATE 	= "hidSelectDate";

	// tB[hyѐ
	public static final String NAM_K_CODE 			= CommonConst.NAM_K_CODE;
	public static final String NAM_K_NAME 			= CommonConst.NAM_K_NAME;	
	public static final String NAM_SECTION			= CommonConst.NAM_STATION;
	public static final String NAM_CALCULATE_TARGET 	= CommonConst.NAM_TARGET_MONTH;
	public static final String NAM_APPROVAL			= CommonConst.NAM_REMAIN_APPROVED;
	public static final String NAM_COMPILE			= CommonConst.NAM_REMAIN_COMPILE;

	public static final int	LEN_K_CODE = CommonConst.LEN_K_CODE;
	public static final int	LEN_K_NAME = CommonConst.LEN_K_NAME;

	// tB[h
	private String	txtKCode;
	private String	txtKName;
	private String	pltSection;
	private String	pltYear;
	private String	pltMonth;
	private String	pltApproval;
	private String	pltCompile;
	private String hidSelectDate;

	private String[][] aryCompile;

	// v_EXg
	public String[][] aryPltYear ;
	public String[][] aryPltMonth;
	public String[][] aryPltSectionAll;
	public String[][] aryPltSection;
	public String[][] aryPltApprovalFlag;
	public String[][] aryPltCompileFlag;

	// \[gL[
	public final String KEY_K_CODE 		= "keyKCode";
	public final String KEY_K_NAME 		= "keyKName";
	public final String KEY_SECTION 		= "keySection";

	// [h(0FȂA1F)
	private int searchmode;

	// ΑӏF@\[h(0FLA1F)
	private int mode;

	/**
	 * RXgN^
	 */
	public CompileAmendmentListVo() {
		super();
		setRetUrl(RETURN_URL);
		addExtraJs(EXTRA_JS);
		setExtraCss(EXTRA_CSS);
		mode = MODE_IMPOSSIBLE;
		txtKCode 		= "";
		txtKName 		= "";
		pltSection 		= "";
		pltYear 		= "";
		pltMonth 		= "";
		pltApproval 	= "";
		pltCompile 		= "";
		hidSelectDate 	= "";
		setFormerKey(KEY_K_CODE);
		aryCompile = new String[0][0];
		searchmode = SEARCH_OFF;
	}

	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	public void setParams(HttpServletRequest request) {
		txtKCode 	= request.getParameter(PRM_TXT_K_CODE);
		txtKName 	= request.getParameter(PRM_TXT_K_NAME);
		pltSection 	= request.getParameter(PRM_PLT_SECTION);
		pltYear 	= request.getParameter(PRM_PLT_YEAR);
		pltMonth 	= request.getParameter(PRM_PLT_MONTH);
		pltApproval = request.getParameter(PRM_PLT_APPROVAL);
		pltCompile 	= request.getParameter(PRM_PLT_COMPILE);
	}

	/**
	 * tB[hݒ
	 * @param listCompile ΑӏWvʃXg
	 */
	public void setFields(List listCompile) {
		// Xg̐ݒ
		this.list = listCompile;
		// f[^̎擾
		count = list.size();
		// z̏
		aryCompile = new String[count][15];
		// f[^̐ݒ
		int i = 0;
		Iterator it = list.iterator();
		while (it.hasNext()) {
			CompileAmendmentDto dto = (CompileAmendmentDto)it.next();
			// FL
			String isAllAprooved = util.returnTrueIsOff(dto.getApprovalFlag());
			String isCompiled = util.returnTrueIsOn(dto.getCompileflag());
			aryCompile[i][0 ] = escapeHTML(dto.getKCode());
			aryCompile[i][1 ] = escapeHTML(dto.getKName());
			aryCompile[i][2 ] = escapeHTML(getCodeName(dto.getSCode(), aryPltSectionAll));
			aryCompile[i][3 ] = String.valueOf(dto.getSNissu());
			aryCompile[i][4 ] = String.valueOf(dto.getYukyu());
			aryCompile[i][5 ] = String.valueOf(dto.getTokuKyu());
			aryCompile[i][6 ] = String.valueOf(dto.getKekkin());
			aryCompile[i][7 ] = util.getHourString(util.convIntegerTimeToDoubleTime(dto.getKinmuJi()));
			aryCompile[i][8 ] = util.getHourString(util.convIntegerTimeToDoubleTime(dto.getKyukeiJi()));
			aryCompile[i][9 ] = util.getHourString(util.convIntegerTimeToDoubleTime(dto.getTisoJi()));
			aryCompile[i][10] = util.getHourString(util.convIntegerTimeToDoubleTime(dto.getZaJikan()));
			aryCompile[i][11] = util.getHourString(util.convIntegerTimeToDoubleTime(dto.getKsJikan()));
			aryCompile[i][12] = util.getHourString(util.convIntegerTimeToDoubleTime(dto.getSnJikan()));
			aryCompile[i][13] = getCodeName(isAllAprooved, aryPltApprovalFlag);
			aryCompile[i][14] = getCodeName(isCompiled, aryPltCompileFlag);
			i++;
		}
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}

	// ANZT\bh
	public String[][] getAryCompile	() { return aryCompile.clone()	; }

	public String getTxtKCode		() { return txtKCode	; }
	public String getTxtKName		() { return txtKName	; }
	public String getPltSection		() { return pltSection	; }
	public String getPltYear		() { return pltYear		; }
	public String getPltMonth		() { return pltMonth  	; }
	public String getPltApproval	() { return pltApproval	; }
	public String getPltCompile		() { return pltCompile	; }

	public String getEscTxtKCode	() { return escapeHTML(txtKCode)	; }
	public String getEscTxtKName	() { return escapeHTML(txtKName)	; }
	public String getEscPltApproval	() { return escapeHTML(pltApproval)	; }
	public String getEscPltCompile	() { return escapeHTML(pltCompile)	; }

	public void setTxtKCode	(String txtKCode	){ this.txtKCode 	= txtKCode		; }
	public void setTxtKName	(String txtKName	){ this.txtKName 	= txtKName		; }
	public void setPltSection	(String pltSection	){ this.pltSection 	= pltSection	; }
	public void setPltYear		(String pltYear		){ this.pltYear 	= pltYear		; }
	public void setPltMonth	(String pltMonth	){ this.pltMonth 	= pltMonth		; }
	public void setPltApproval	(String pltApproval	){ this.pltApproval	= pltApproval	; }
	public void setPltCompile	(String pltCompile	){ this.pltCompile 	= pltCompile	; }

	public String getHidSelectDate() { return hidSelectDate; }
	public void setHidSelectDate(String hidSelectDate) { this.hidSelectDate = hidSelectDate; }

	public void setSearchmode(int searchmode) { this.searchmode = searchmode; }
	public int getSearchmode() { return searchmode; }

	public void setMode(int mode) { this.mode = mode; }
	public int getMode() { return mode; }

}
